/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import javax.annotation.Nullable;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.Activatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingUtil {
    private static final Logger log = LoggerFactory.getLogger(SwingUtil.class);

    public static void removeButtonDecorations(AbstractButton button) {
        button.putClientProperty("FlatLaf.styleClass", "iconButton legacyIconButton");
    }

    public static void addModalTooltip(AbstractButton button, String on, String off) {
        button.setToolTipText(button.isSelected() ? on : off);
        button.addItemListener(l2 -> button.setToolTipText(button.isSelected() ? on : off));
    }

    public static void fastRemoveAll(Container c2) {
        assert (SwingUtilities.isEventDispatchThread());
        c2.invalidate();
        for (int i2 = 0; i2 < c2.getComponentCount(); ++i2) {
            Component ic2 = c2.getComponent(i2);
            if (ic2 instanceof Container) {
                SwingUtil.fastRemoveAll((Container)ic2);
            }
            SwingUtil.pumpPendingEvents();
            ic2.removeNotify();
        }
        c2.removeAll();
    }

    public static void pumpPendingEvents() {
        EventQueue eq2 = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (eq2.peekEvent() != null) {
            SecondaryLoop l2 = eq2.createSecondaryLoop();
            SwingUtilities.invokeLater(l2::exit);
            l2.enter();
        }
    }

    public static void activate(@Nullable Object maybeActivatable) {
        if (maybeActivatable instanceof Activatable) {
            try {
                ((Activatable)maybeActivatable).onActivate();
            }
            catch (Exception e2) {
                log.warn("uncaught exception in activate", e2);
            }
        }
    }

    public static void deactivate(@Nullable Object maybeActivatable) {
        if (maybeActivatable instanceof Activatable) {
            try {
                ((Activatable)maybeActivatable).onDeactivate();
            }
            catch (Exception e2) {
                log.warn("uncaught exception in deactivate", e2);
            }
        }
    }
}

